function CDX_new = initialize_parameters_cdx(CDX, discounts_IMM, method)
% --------------------------------------------------------------------------------------------------
% Initialize the parameters for the individual credit default swaps, credit indices and tranches.
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% method    ... allows to customize parameter initalization
% --------------------------------------------------------------------------------------------------
% sample call: initialize_parameters_cdx(CDX, discounts_IMM, 1)
% --------------------------------------------------------------------------------------------------

% Initialize parameters for AJD dynamics of CDS, to make sure that parameters are in order k,theta,sigma,L,mu
for i=1:length(CDX.portfolio)
    cds = CDX.portfolio(i);
    cds.AJD = struct('k', 0.01, 'theta', 0.01, 'sigma', 0.01, 'L', 0.01, 'mu', 0.01, 'dates', CDX.dates{1});
    if (i==1)
        new_port = cds;
    else
        new_port(i) = cds;
    end
end
CDX.portfolio = new_port;

% Initialize AJD and LGD dynamics so that parameters are in right order
CDX.AJD_common_factor = struct('k', 0.01, 'theta', 0.01, 'sigma', 0.01, 'L', 0.01, 'mu', 0.01, 'dates', CDX.dates{1});
CDX.LGD = struct('mean', 0.6, 'alpha_n_rel', repmat(0.1, 1, 126), 'rho_n', repmat(0.2, 1, 125));
CDX.liq_prem_tranches = repmat(0.00, length(CDX.dates{1}), 1);
CDX.liq_prem_cds = repmat(0.08, length(CDX.dates{1}), 1);
                 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Time-homogenous parameters %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Use resonable parameters (fitted for 02/01/2006)
if (method == 1)
    % Set common AJD parameters
    CDX.y0 = 0.001435;
    CDX = set_k(CDX, 0.0189);
    CDX = set_sigma(CDX, 0.0333);
    CDX = set_L_total(CDX, 0.0168); 
    CDX = set_mu(CDX, 0.0840);
    CDX = set_omega1(CDX, 0.4172); 
    CDX = set_theta_omega2(CDX, 0.0613, 0.9896);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, datenum('02/01/2006'), datenum('02/01/2006'), [1 0 0 1]);
end

% Yearly data
if (method == 2)
    % Set common AJD parameters
    CDX = set_k(CDX, 0.01153809);
    CDX = set_sigma(CDX, 0.0286);
    CDX = set_L_total(CDX, 0.0142); 
    CDX = set_mu(CDX, 0.0977);
    CDX = set_omega1(CDX, 0.3473); 
    CDX = set_theta_omega2(CDX, 0.1124, 0.5844);
    
    % Set intensity parameters and liquidity premium
    CDX.y0 = repmat(0.00202661, length(CDX.dates{1}), 1);
    CDX.liq_prem_tranches = repmat(0.00, length(CDX.dates{1}), 1);
    CDX.liq_prem_cds = repmat(0.12, length(CDX.dates{1}), 1);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, CDX.dates{1}(1), CDX.dates{1}(end), [1 0 0 1]);
end

% Use resonable parameters (monthly data)
if (method == 3)
    % Set common AJD parameters
    CDX = set_k(CDX, 0.0775);
    CDX = set_sigma(CDX, 0.0564);
    CDX = set_L_total(CDX, 0.0171); 
    CDX = set_mu(CDX, 0.0324);
    CDX = set_omega1(CDX, 0.3824); 
    CDX = set_theta_omega2(CDX, 0.0474, 0.8145);
    
    % Set intensity parameters and liquidity premium
    CDX.y0 = repmat(0.0005, length(CDX.dates{1}), 1);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, CDX.dates{1}(1), CDX.dates{1}(end), [1 0 0 1]);
end

% Use resonable parameters (fitted for Feb,Mar,Apr,May 2006)
if (method == 104)
    % Set common AJD parameters
    CDX.y0 = repmat(0.001435, length(CDX.dates{1}), 1);
    CDX = set_k(CDX, 0.0263);
    CDX = set_sigma(CDX, 0.0517);
    CDX = set_L_total(CDX, 0.0126); 
    CDX = set_mu(CDX, 0.1);
    CDX = set_omega1(CDX, 0.3762); 
    CDX = set_theta_omega2(CDX, 0.0394, 0.9996);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, CDX.dates{1}(1), CDX.dates{1}(end), [1 0 0 1]);
end

% Use resonable parameters (fitted for Feb-Sep 2006)
if (method == 105)
    % Set common AJD parameters
    CDX.y0 = repmat(0.001477, length(CDX.dates{1}), 1);
    CDX = set_k(CDX, 0.022);
    CDX = set_sigma(CDX, 0.0415);
    CDX = set_L_total(CDX, 0.0180); 
    CDX = set_mu(CDX, 0.0607);
    CDX = set_omega1(CDX, 0.3524); 
    CDX = set_theta_omega2(CDX, 0.00656, 0.8878);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, CDX.dates{1}(1), CDX.dates{1}(end), [1 0 0 1]);
end

% Use resonable parameters (fitted for 12/05/2005 as in Mortensen paper)
if (method == 106)
    % Set common AJD parameters
    CDX = set_k(CDX, 0.01153809);
    CDX = set_sigma(CDX, 0.0286);
    CDX = set_L_total(CDX, 0.0142); 
    CDX = set_mu(CDX, 0.0977);
    CDX = set_omega1(CDX, 0.3473); 
    CDX = set_theta_omega2(CDX, 0.1124, 0.5844);
      
    % Set intensity parameters and liquidity premium
    CDX.y0 = 0.00202661;
    CDX.liq_prem_tranches = 0.00;
    CDX.liq_prem_cds = 0.12;
    
    % Initialize x0
    for i=1:length(CDX.portfolio)
        CDX.portfolio(i).x0 = ones(size(CDX.portfolio(i).dates{1}));
    end
        
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, datenum('12/05/2005'), datenum('12/05/2005'), [1 0 0 1]);
end

% Use resonable parameters (fitted for Sep04-Nov06)
if (method == 107)
    % Set common AJD parameters
    CDX.y0 = repmat(0.001477, length(CDX.dates{1}), 1);
    CDX = set_k(CDX, 0.02);
    CDX = set_sigma(CDX, 0.024);
    CDX = set_L_total(CDX, 0.012); 
    CDX = set_mu(CDX, 0.0607);
    CDX = set_omega1(CDX, 0.3524); 
    CDX = set_theta_omega2(CDX, 0.00656, 0.8878);
    
    % Initialize x0
    for i=1:length(CDX.portfolio)
        CDX.portfolio(i).x0 = zeros(size(CDX.portfolio(i).dates{1}));
    end
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, CDX.dates{1}(1), CDX.dates{1}(end), [1 0 0 1]);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Partially time-varying parameters %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Time variation in omega1 (fitted for 02/01/2006 and 3/1/2006)
if (method == 4)
    % Set common AJD parameters
    CDX.y0 = [0.001416; 0.001416];
    CDX = set_k(CDX, 0.01314);
    CDX = set_sigma(CDX, 0.034);
    CDX = set_L_total(CDX, 0.0177); 
    CDX = set_mu(CDX, 0.0675);
    CDX = set_omega1(CDX, [0.3184; 0.3184]); 
    CDX = set_theta_omega2(CDX, 0.0078, 0.9649);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, datenum('02/01/2006'), datenum('03/01/2006'), [1 0 0 1]);
end

% Time variation in k (fitted for 02/01/2006 and 3/1/2006)
if (method == 5)
    % Set common AJD parameters
    CDX.y0 = [0.001416; 0.001416];
    CDX = set_k(CDX, [0.01314; 0.01314]);
    CDX = set_sigma(CDX, 0.034);
    CDX = set_L_total(CDX, 0.0177); 
    CDX = set_mu(CDX, 0.0675);
    CDX = set_omega1(CDX, 0.3184); 
    CDX = set_theta_omega2(CDX, 0.0078, 0.9649);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, datenum('02/01/2006'), datenum('03/01/2006'), [1 0 0 1]);
end

% Time variation in theta_total (fitted for 02/01/2006 and 3/1/2006)
if (method == 6)
    % Set common AJD parameters
    CDX.y0 = [0.001416; 0.001416];
    CDX = set_k(CDX, 0.01314);
    CDX = set_sigma(CDX, 0.034);
    CDX = set_L_total(CDX, 0.0177); 
    CDX = set_mu(CDX, 0.0675);
    CDX = set_omega1(CDX, 0.3184); 
    CDX = set_theta_omega2(CDX, [0.0078; 0.0078], 0.9649);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, datenum('02/01/2006'), datenum('03/01/2006'), [1 0 0 1]);
end

% Time variation in sigma (fitted for 02/01/2006 and 3/1/2006)
if (method == 7)
    % Set common AJD parameters
    CDX.y0 = [0.001416; 0.001416];
    CDX = set_k(CDX, 0.01314);
    CDX = set_sigma(CDX, [0.034; 0.034]);
    CDX = set_L_total(CDX, 0.0177); 
    CDX = set_mu(CDX, 0.0675);
    CDX = set_omega1(CDX, 0.3184); 
    CDX = set_theta_omega2(CDX, 0.0078, 0.9649);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, datenum('02/01/2006'), datenum('03/01/2006'), [1 0 0 1]);
end

% Time variation in L_total (fitted for 02/01/2006 and 3/1/2006)
if (method == 8)
    % Set common AJD parameters
    CDX.y0 = [0.001416; 0.001416];
    CDX = set_k(CDX, 0.01314);
    CDX = set_sigma(CDX, 0.034);
    CDX = set_L_total(CDX, [0.0177; 0.0177]); 
    CDX = set_mu(CDX, 0.0675);
    CDX = set_omega1(CDX, 0.3184); 
    CDX = set_theta_omega2(CDX, 0.0078, 0.9649);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, datenum('02/01/2006'), datenum('03/01/2006'), [1 0 0 1]);
end

% Time variation in mu (fitted for 02/01/2006 and 3/1/2006)
if (method == 9)
    % Set common AJD parameters
    CDX.y0 = [0.001416; 0.001416];
    CDX = set_k(CDX, 0.01314);
    CDX = set_sigma(CDX, 0.034);
    CDX = set_L_total(CDX, 0.0177); 
    CDX = set_mu(CDX, [0.0675; 0.0675]);
    CDX = set_omega1(CDX, 0.3184); 
    CDX = set_theta_omega2(CDX, 0.0078, 0.9649);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, datenum('02/01/2006'), datenum('03/01/2006'), [1 0 0 1]);
end

% Time variation in omega2 (fitted for 02/01/2006 and 3/1/2006)
if (method == 10)
    % Set common AJD parameters
    CDX.y0 = [0.001416; 0.001416];
    CDX = set_k(CDX, 0.01314);
    CDX = set_sigma(CDX, 0.034);
    CDX = set_L_total(CDX, 0.0177); 
    CDX = set_mu(CDX, 0.0675);
    CDX = set_omega1(CDX, 0.3184); 
    CDX = set_theta_omega2(CDX, 0.0078, [0.9649; 0.9649]);
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, datenum('02/01/2006'), datenum('03/01/2006'), [1 0 0 1]);
end

% Add date time series to parameters
CDX.AJD_common_factor.dates = CDX.dates{1};
for i=1:length(CDX.portfolio)
    cds = CDX.portfolio(i);
    cds.AJD.dates = cds.dates{1};
    if (i==1)
        port_new = cds;
    else
        port_new = [port_new; cds];
    end
end
CDX.portfolio = port_new;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fully time-varying parameters %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Yearly data
if (method == 101)
    % Set common AJD parameters
    num_dates = length(CDX.dates{1});
    CDX = set_k(CDX, repmat(0.0150, num_dates, 1), CDX.dates{1});
    CDX = set_sigma(CDX, repmat(0.0706, num_dates, 1), CDX.dates{1});
    CDX = set_L_total(CDX, repmat(0.0130, num_dates, 1), CDX.dates{1}); 
    CDX = set_mu(CDX, repmat(0.1160, num_dates, 1), CDX.dates{1});
    CDX = set_omega1(CDX, repmat(0.3339, num_dates, 1), CDX.dates{1}); 
    CDX = set_theta_omega2(CDX, repmat(0.1103, num_dates, 1), repmat(0.0792, num_dates, 1), CDX.dates{1});
    
    % Set intensity parameters and liquidity premium
    CDX.y0 = [0.0012 0.0012 0.0012]';
    CDX.liq_prem_tranches = [0 0 0]';
    CDX.liq_prem_cds = [0.1177 0.1177 0.1177]';
    
    for i=1:length(CDX.portfolio)
        cds = CDX.portfolio(i);
        cds.ai = repmat(cds.ai, max(1, length(cds.dates{1})), 1);
        cds.bi = ones(max(1, length(cds.dates{1})), 1);
    end
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, CDX.dates{1}(1), CDX.dates{1}(end), [1 0 0 1]);
end

% Quarterly data
if (method == 102)
    % Set common AJD parameters
    num_dates = length(CDX.dates{1});
    CDX = set_k(CDX, repmat(0.0150, num_dates, 1), CDX.dates{1});
    CDX = set_sigma(CDX, repmat(0.0706, num_dates, 1), CDX.dates{1});
    CDX = set_L_total(CDX, repmat(0.0130, num_dates, 1), CDX.dates{1}); 
    CDX = set_mu(CDX, repmat(0.1160, num_dates, 1), CDX.dates{1});
    CDX = set_omega1(CDX, repmat(0.3339, num_dates, 1), CDX.dates{1}); 
    CDX = set_theta_omega2(CDX, repmat(0.1103, num_dates, 1), repmat(0.0792, num_dates, 1), CDX.dates{1});
    
    % Set intensity parameters and liquidity premium
    CDX.y0 = repmat(0.0012, num_dates, 1);
    CDX.liq_prem_tranches = repmat(0, num_dates, 1);
    CDX.liq_prem_cds = repmat(0.12, num_dates, 1);
    
    for i=1:length(CDX.portfolio)
        cds = CDX.portfolio(i);
        if (length(cds.ai) == 1)
            cds.ai = repmat(cds.ai, max(1, length(cds.dates{1})), 1);
        end
        cds.bi = ones(max(1, length(cds.dates{1})), 1);
        if (length(cds.x0) == 1)
            cds.x0 = repmat(0.01, max(1, length(cds.dates{1})), 1);
        end
        if (i == 1)
            portfolio = cds;
        else
            portfolio(i) = cds;
        end
    end
    CDX.portfolio = portfolio;
    
    % Update fit of individual CDS
    CDX = fit_model_cds_portfolio(CDX, discounts_IMM, CDX.dates{1}(1), CDX.dates{1}(end), [1 0 0 1]);
end

% Return CDX with initialized parameters
CDX_new = CDX;
